/*
 * Decompiled with CFR 0.152.
 */
package pse.result;

import org.w3c.dom.Node;
import pse.result.ResultObject;
import pse.result.WorkProduct;
import pse.util.general.Utilities;
import pse.util.general.XmlUtils;
import pse.util.general.XmlWriter;

public class WorkProductSummary
extends ResultObject {
    protected int commandSize;
    protected int pkaSize = 0;
    protected long pkaCheckSum = -1L;

    public String getElementName() {
        return "work-product-summary";
    }

    public boolean hasChildren() {
        return true;
    }

    public int getCommandSize() {
        return this.commandSize;
    }

    public void setCommandSize(int n) {
        this.commandSize = n;
    }

    public int getPkaSize() {
        return this.pkaSize;
    }

    public void setPkaSize(int n) {
        this.pkaSize = n;
    }

    public long getPkaCheckSum() {
        return this.pkaCheckSum;
    }

    public void setPkaCheckSum(long l) {
        this.pkaCheckSum = l;
    }

    public void setPkaContents(byte[] byArray) {
        this.pkaSize = byArray.length;
        this.pkaCheckSum = Utilities.calculateCheckSum(byArray);
    }

    public void summarize(WorkProduct workProduct) {
        this.setPkaContents(workProduct.getPkaContents());
        this.setCommandSize(workProduct.getIosLog().getCommandSize());
    }

    protected void addChildren(XmlWriter xmlWriter) {
        super.addChildren(xmlWriter);
        xmlWriter.addElement("pka-summary", "size", this.pkaSize, "checksum", this.pkaCheckSum);
        xmlWriter.addElement("log-summary", "command-size", this.commandSize);
    }

    protected void readChildrenFromMyNode(Node node) {
        super.readChildrenFromMyNode(node);
        Node node2 = XmlUtils.getChild(node, "pka-summary");
        this.pkaSize = XmlUtils.getIntAttribute(node2, "size", 0);
        this.pkaCheckSum = XmlUtils.getLongAttribute(node2, "checksum", -1L);
        Node node3 = XmlUtils.getChild(node, "log-summary");
        this.commandSize = XmlUtils.getIntAttribute(node3, "command-size", 0);
    }
}

